import arcpy, sys, traceback

#Input Variables
arcpy.env.workspace = arcpy.GetParameterAsText(0)  #r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles"
workspace = arcpy.env.workspace
layerFile = arcpy.GetParameterAsText(1) #r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles\Point.lyr"

#Defined Variables
seedAnno = r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles\SeedFile\Annotation.lyr"
seedMulti = r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles\SeedFile\Multipatch.lyr"
seedArea = r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles\SeedFile\Polygon.lyr"
seedLine = r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles\SeedFile\Polyline.lyr"
seedPoint = r"D:\Data\Data_Customer\AlaskaDOT\LayerFiles\SeedFile\Point.lyr"

try:
    # Script Logic
    desc = arcpy.Describe(layerFile)
    geoName = desc.name.split(".")[0]
    geoType = desc.shapeType
    arcpy.AddMessage("Processing " + geoName + " layer file. It is a geometry type of: " + geoType)
    
    if geoType == 'Annotation' and geoName == "Annotation":
            arcpy.ApplySymbologyFromLayer_management (layerFile, seedAnno)
            arcpy.AddMessage(geoType + " layer symbolgy has been applied.")
            print geoType + " geometry symbolgy has been applied"            
    elif geoType == 'Multipatch' and geoName == "Multipatch":
        arcpy.ApplySymbologyFromLayer_management (layerFile, seedMulti)
        arcpy.AddMessage(geoType + " layer symbolgy has been applied.")
        print geoType + " geometry symbolgy has been applied"        
    elif geoType == 'Polygon' and geoName == "Polygon":
        arcpy.ApplySymbologyFromLayer_management (layerFile, seedArea)
        arcpy.AddMessage(geoType + " layer symbolgy has been applied.")
        print geoType + " geometry symbolgy has been applied"        
    elif geoType == 'Polyline' and geoName == "Polyline":
        arcpy.ApplySymbologyFromLayer_management (layerFile, seedLine)
        arcpy.AddMessage(geoType + " layer symbolgy has been applied.")
        print geoType + " geometry symbolgy has been applied"        
    elif geoType == 'Point' and geoName == "Point":
        arcpy.ApplySymbologyFromLayer_management (layerFile, seedPoint)
        arcpy.AddMessage(geoType + " layer symbolgy has been applied.")
        print geoType + " geometry symbolgy has been applied"        
    else:
        arcpy.AddMessage(geoType + " geometry type did not match the " + geoName + " layer") 
        
    arcpy.SetParameter(1, True)
except arcpy.ExecuteError: 
    # Get the tool error messages 
    # 
    msgs = arcpy.GetMessages(2) 

    # Return tool error messages for use with a script tool 
    #
    arcpy.AddError(msgs) 

    # Print tool error messages for use in Python/PythonWin 
    # 
    print(msgs)
except:
    # Get the traceback object
    #
    tb = sys.exc_info()[2]
    tbinfo = traceback.format_tb(tb)[0]

    # Concatenate information together concerning the error into a message string
    #
    pymsg = "PYTHON ERRORS:\nTraceback info:\n" + tbinfo + "\nError Info:\n" + str(sys.exc_info()[1])
    msgs = "ArcPy ERRORS:\n" + arcpy.GetMessages(2) + "\n"

    # Return python error messages for use in script tool or Python Window
    #
    arcpy.AddError(pymsg)
    arcpy.AddError(msgs)

    # Print Python error messages for use in Python / Python Window
    #
    print(pymsg)
    print(msgs)