import arcpy, os
workspace = arcpy.GetParameterAsText(0)
mxdName = arcpy.GetParameterAsText(1)
mxdOutName = arcpy.GetParameterAsText(2)
mxd = arcpy.mapping.MapDocument(mxdName)
df = arcpy.mapping.ListDataFrames(mxd, "*")[0]

walk = arcpy.da.Walk(workspace, datatype="Layer")

for dirpath, dirnames, filenames in walk:
    for filename in filenames:
        arcpy.mapping.AddLayer(df, arcpy.mapping.Layer(os.path.join(dirpath, filename)))

mxdOut = mxdOutName + ".mxd"
mxd.saveACopy(mxdOut)
arcpy.AddMessage(mxdOut + " created on " + str(dirpath))
arcpy.SetParameter(1, True)

