import arcpy, os, sys

arcpy.CheckOutExtension("3D")

inputFeatureDataset = arcpy.GetParameterAsText(0)
arcpy.env.workspace = inputFeatureDataset

inputTerrain = "projectSurface"
terrainPath = os.path.join(arcpy.env.workspace, inputTerrain)
terrainPath =  terrainPath.replace("\\", "\\\\")

#remove empty feature classes
listFCS = arcpy.ListFeatureClasses()
for fc in listFCS:
       count1 = str(arcpy.GetCount_management(fc))  
       if count1 == "0":  
              arcpy.Delete_management(fc)    

#Add feature classes to Terrain
fcs = arcpy.ListFeatureClasses()
seq = [str(x) for x in fcs]
for text in seq:
       if 'Contours' in text:
              inFC = os.path.join(arcpy.env.workspace, text)
              inFC = inFC.replace("\\", "\\\\")
              params =  inFC + " Elevation softline 1 0 16 false false Contours_embed <None> false"
              arcpy.AddFeatureClassToTerrain_3d(terrainPath, params)
       #elif 'Shoulder' in text:
              #inFC = os.path.join(arcpy.env.workspace, text)
              #inFC = inFC.replace("\\", "\\\\")
              #params =  inFC + " Shape hardline 2 0 16 false false Shoulder_embed <None> false" 
              #arcpy.AddFeatureClassToTerrain_3d(terrainPath, params)              
       elif 'ProjectBoundary' in text:
              inFC = os.path.join(arcpy.env.workspace, text)
              inFC = inFC.replace("\\", "\\\\")
              params =  inFC + " Shape hardclip 3 0 16 true false ProjBound_embed <None> false"
              arcpy.AddFeatureClassToTerrain_3d(terrainPath, params)
       #elif 'Spot_Elevation' in text:
              #inFC = os.path.join(arcpy.env.workspace, text)
              #inFC = inFC.replace("\\", "\\\\")
              #params =  inFC + " Elevation masspoints 1 0 16 true false SpotElev_embed <None> true"
              #arcpy.AddFeatureClassToTerrain_3d(terrainPath, params)    

arcpy.BuildTerrain_3d(terrainPath, "NO_UPDATE_EXTENT")
arcpy.SetParameter(1, True)
arcpy.AddMessage("Terrain has been loaded and built.")




    