import arcpy
from arcpy import env
import os

env.overwriteOutput = True

inFC = arcpy.GetParameterAsText(0) #r"D:\Data\Data_Customer\AlaskaDOT\CAD_Files\64121_SV.dwg"
extentPoly =  arcpy.GetParameterAsText(1)  # str(env.scratchWorkspace) + os.sep + r"D:\Data\Data_Customer\AlaskaDOT\64121_SV.gdb\CAD_Boundary"
arcpy.AddMessage(extentPoly)
# Feature extent
#
desc = arcpy.Describe(inFC)
print("%-12s %s" % ("is2D:", desc.is2D))
arcpy.AddMessage("%-12s %s" % ("is2D:", desc.is2D))
print("%-12s %s" % ("is3D:", desc.is3D))
arcpy.AddMessage("%-12s %s" % ("is3D:", desc.is3D))
print("%-12s %s" % ("isAutoCAD:", desc.isAutoCAD))
arcpy.AddMessage("%-12s %s" % ("isAutoCAD:", desc.isAutoCAD))
print("%-12s %s" % ("isDGN:", desc.isDGN))
arcpy.AddMessage("%-12s %s" % ("isDGN:", desc.isDGN))
extent = arcpy.Describe(inFC).extent
print extent
arcpy.AddMessage(extent)
# Array to hold points
#
array = arcpy.Array()
# Create the bounding box
array.add(extent.lowerLeft)
print extent.lowerLeft
array.add(extent.lowerRight)
array.add(extent.upperRight)
array.add(extent.upperLeft)
# ensure the polygon is closed
array.add(extent.lowerLeft)
# Create the polygon object
polygon = arcpy.Polygon(array)
array.removeAll()
# save to disk
arcpy.CopyFeatures_management(polygon, extentPoly)
del polygon